MODULE FUP_0_16_D
!   
!  U PROGRAMU KOJI UKLJUCUJE (MODULE FUP_0_16) POTREBNOJE DA PRVA IZVRSNA NAREDBA BUDE
! ******************  CALL  RACUN  ******************
!   
!
!  MODUL DONOSI U GLAVNI PROGRAM POLJA S VRIJEDNOSTIMA DERIVACIJA FUNKCIJE
!  FUPn(x),  NA RAZMAKU 2**(-M), M = 16,  n = 0-0,...,16-16
!         !!!  N A J B R Z A   V A R I J A N T A  !!!
!  Derivacije za pojedinu funkciju Fupn(x) se izracunavaju od nultog do n-tog reda




   PUBLIC RACUN, FUPN  !

   PRIVATE UPTURBOX, FUP00, FUP01, FUP02, FUP03, FUP04, FUP05, FUP06, FUP07,  &
                      FUP08, FUP09, FUP10, FUP11, FUP12, FUP13, FUP14, FUP15, FUP16, &
                      NFUP, VERTEX, XPOINT, DELTAX, KOD, K,M,N,KK,J00,J01,J02,J03,  &
                      WORK, D,C00,DX,DX0 


   CONTAINS

   SUBROUTINE RACUN
    
!
!  PODPROGRAM VRACA POLJA S VRIJEDNOSTIMA DERIVACIJA FUNKCIJE FUPn(x) NA RAZMAKU 2**(-M), M = 16
!  n = 0-0,...,16-16         !!!  N A J B R Z A   V A R I J A N T A  !!!
!
   INTEGER(4) :: K,M,N,KK,J00,J01,J02,J03

   real(kind=8)  D,C00,DX,DX0
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16

   DIMENSION D(32)
   real(8), ALLOCATABLE :: WORK(:,:)
   !(-2*65536:65536,0:16)

!   PARAMETER ( M = 16 )
!   PARAMETER ( DX = 1.0D0 )  ! DEFAULT, INACE SE MORA ZADATI KONKRETNA VRIJEDNOST ' DX '
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)

!   CALL CPU_TIME(T0)
!   WRITE(*,*) T0

   M  = 16
   DX = 1.D0   ! DEFAULT, INACE SE MORA ZADATI KONKRETNA VRIJEDNOST ' DX '


!!! Calculate coefficient Delta (+-1)

   D(1) = 1.D0
   DO K = 1,16
   D(2*K-1) = D(K)
   D(2*K) = -D(K)
   END DO

!!! Fill array of U (value of UP function - 2E16)

          CALL UPTURBOX(M)

!IZRACUNAVANJE SVIH DERIVACIJA FUNKCIJE up(x)


      ALLOCATE (WORK(-2*65536:65536,0:16))
         K = -2**M
      DO K = -2**M,2**M
      WORK(K,0) = FUP_00(K, 0)
     
      END DO
         N = 1
      DO N = 1,M  !!!+1  !!!!
              K = 0
           DO K = 0,2**(M-N+1) 
           WORK(-2**M+K,N) = 2.0D0**((N*(N+1))/2)*FUP_00(-2**M+K*2**N,0)
           END DO
      END DO
         N = 2
      DO N = 2,M   !!!+1   !!!
           DO K = 0,2**(M-N+1)
                           KK = 2
                        DO KK = 2,N
     WORK(-2**M+2**(M-N+1)*(KK-1)+K, N) = D(KK)*WORK(-2**M+K,N)
                         END DO
           END DO
      END DO


!    Izracunavanje vrijednosti nulte i prvih (N+1) derivacija funkcije Fupn(x)
           N = 0
        DO N = 0,M
              J00 = 2**M
              J01 = ((N+2)*2**(M-N))/2
  J02 = 0
  J03 = 2**(M-N)
 C00 = 2.0D0**((N*(N+1))/2) 

  DX0 = 2.0D0**(-N)
                      
                           IF(N == 1) THEN
                    KK = 0
                 DO KK = 0,N+1  !!!
                     K = 0
                 DO  K = 0,J01            
 FUP_01(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-WORK(-J00-J03+K,KK))
     FUP_01( J01-K,KK) = (-1.0D0)**KK*FUP_01(-J01+K,KK)
                 END DO
                 END DO
          
                      ELSE IF(N == 2) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
  DO  K = 0,J01           
FUP_02(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-2.0D0*WORK(-J00-J03+K,KK))
FUP_02( J01-K,KK) = (-1.0D0)**KK*FUP_02(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 3) THEN
 			
                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
  DO  K = 0,J01          
FUP_03(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-3.0D0*WORK(-J00-J03+K,KK)+ &
              4.0D0*WORK(-J00-2*J03+K,KK))
 FUP_03( J01-K,KK) = (-1.0D0)**KK*FUP_03(-J01+K,KK)
                 END DO
                 END DO
 
                      ELSE IF(N == 4) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
     DO  K = 0,J01           
 FUP_04(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-4.0D0*WORK(-J00-J03+K,KK)+ &
                  7.0D0*WORK(-J00-2*J03+K,KK))
     FUP_04( J01-K,KK) = (-1.0D0)**KK*FUP_04(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 5) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
     DO  K = 0,J01   
 FUP_05(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-5.0D0*WORK(-J00-J03+K,KK)+ &
                   11.0D0*WORK(-J00-2*J03+K,KK)-15.0D0*WORK(-J00-3*J03+K,KK))
     FUP_05( J01-K,KK) = (-1.0D0)**KK*FUP_05(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 6) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
     DO  K = 0,J01              
 FUP_06(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-6.0D0*WORK(-J00-J03+K,KK)+ &
                 16.0D0*WORK(-J00-2*J03+K,KK)-26.0D0*WORK(-J00-3*J03+K,KK))
     FUP_06( J01-K,KK) = (-1.0D0)**KK*FUP_06(-J01+K,KK)
                 END DO
                 END DO
 
                     ELSE IF(N == 7) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
    DO  K = 0,J01              
 FUP_07(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-7.0D0*WORK(-J00-J03+K,KK)+ &
  22.0D0*WORK(-J00-2*J03+K,KK)-42.0D0*WORK(-J00-3*J03+K,KK)+ &
 58.0D0*WORK(-J00-4*J03+K,KK))
     FUP_07( J01-K,KK) = (-1.0D0)**KK*FUP_07(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 8) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
  DO  K = 0,J01             
FUP_08(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-8.0D0*WORK(-J00-J03+K,KK)+ &
 29.0D0*WORK(-J00-2*J03+K,KK)-64.0D0*WORK(-J00-3*J03+K,KK)+ &
 100.0D0*WORK(-J00-4*J03+K,KK))
     FUP_08( J01-K,KK) = (-1.0D0)**KK*FUP_08(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 9) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
 DO  K = 0,J01              
FUP_09(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-9.0D0*WORK(-J00-J03+K,KK)+ &
 37.0D0*WORK(-J00-2*J03+K,KK)-93.0D0*WORK(-J00-3*J03+K,KK)+ &
164.0D0*WORK(-J00-4*J03+K,KK)-228.0D0*WORK(-J00-5*J03+K,KK))
     FUP_09( J01-K,KK) = (-1.0D0)**KK*FUP_09(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 10) THEN
                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
 DO  K = 0,J01           
FUP_10(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-10.0D0*WORK(-J00-J03+K,KK)+ &
           46.0D0*WORK(-J00-2*J03+K,KK)-130.0D0*WORK(-J00-3*J03+K,KK)+ &
  257.0D0*WORK(-J00-4*J03+K,KK)-392.0D0*WORK(-J00-5*J03+K,KK))
     FUP_10( J01-K,KK) = (-1.0D0)**KK*FUP_10(-J01+K,KK)
                 END DO
                 END DO

 ELSE IF(N == 11) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
   DO  K = 0,J01               
FUP_11(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-11.0D0*WORK(-J00-J03+K,KK)+ &
 56.0D0*WORK(-J00-2*J03+K,KK)-176.0D0*WORK(-J00-3*J03+K,KK)+ &
  387.0D0*WORK(-J00-4*J03+K,KK)-649.0D0*WORK(-J00-5*J03+K,KK)+ &
 904.0D0*WORK(-J00-6*J03+K,KK))
     FUP_11( J01-K,KK) = (-1.0D0)**KK*FUP_11(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 12) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
  DO  K = 0,J01              
 FUP_12(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-12.0D0*WORK(-J00-J03+K,KK)+ &
  67.0D0*WORK(-J00-2*J03+K,KK)-232.0D0*WORK(-J00-3*J03+K,KK)+ &
 563.0D0*WORK(-J00-4*J03+K,KK)-1036.0D0*WORK(-J00-5*J03+K,KK)+ &
   1553.0D0*WORK(-J00-6*J03+K,KK))
     FUP_12( J01-K,KK) = (-1.0D0)**KK*FUP_12(-J01+K,KK)

                 END DO
                 END DO

                      ELSE IF(N == 13) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
  DO  K = 0,J01              
 FUP_13(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-13.0D0*WORK(-J00-J03+K,KK)+ &
                  79.0D0*WORK(-J00-2*J03+K,KK)-299.0D0*WORK(-J00-3*J03+K,KK)+ &
  795.0D0*WORK(-J00-4*J03+K,KK)-1599.0D0*WORK(-J00-5*J03+K,KK)+ &
   2589.0D0*WORK(-J00-6*J03+K,KK)-3601.0D0*WORK(-J00-7*J03+K,KK))
     FUP_13( J01-K,KK) = (-1.0D0)**KK*FUP_13(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 14) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
  DO  K = 0,J01              
FUP_14(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-14.0D0*WORK(-J00-J03+K,KK)+ &
92.0D0*WORK(-J00-2*J03+K,KK)-378.0D0*WORK(-J00-3*J03+K,KK)+ &
1094.0D0*WORK(-J00-4*J03+K,KK)-2394.0D0*WORK(-J00-5*J03+K,KK)+ &
4188.0D0*WORK(-J00-6*J03+K,KK)-6190.0D0*WORK(-J00-7*J03+K,KK))
     FUP_14( J01-K,KK) = (-1.0D0)**KK*FUP_14(-J01+K,KK)

                 END DO
                 END DO

                      ELSE IF(N == 15) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
 DO  K = 0,J01               
FUP_15(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-15.0D0*WORK(-J00-J03+K,KK)+ &
106.0D0*WORK(-J00-2*J03+K,KK)-470.0D0*WORK(-J00-3*J03+K,KK)+ &
1472.0D0*WORK(-J00-4*J03+K,KK)-3488.0D0*WORK(-J00-5*J03+K,KK)+ &
6582.0D0*WORK(-J00-6*J03+K,KK)-10378.0D0*WORK(-J00-7*J03+K,KK)+ &
14384.0D0*WORK(-J00-8*J03+K,KK))
     FUP_15( J01-K,KK) = (-1.0D0)**KK*FUP_15(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 16) THEN

                    KK = 0
                 DO KK = 0,N !!!
                     K = 0
DO  K = 0,J01             
FUP_16(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-16.0D0*WORK(-J00-J03+K,KK)+ &
121.0D0*WORK(-J00-2*J03+K,KK)-576.0D0*WORK(-J00-3*J03+K,KK)+ &
1942.0D0*WORK(-J00-4*J03+K,KK)-4960.0D0*WORK(-J00-5*J03+K,KK)+ &
10070.0D0*WORK(-J00-6*J03+K,KK)-16960.0D0*WORK(-J00-7*J03+K,KK)+ &
24762.0D0*WORK(-J00-8*J03+K,KK))
     FUP_16( J01-K,KK) = (-1.0D0)**KK*FUP_16(-J01+K,KK)
                 END DO
                 END DO

                      END IF
    
      END DO
!
      DEALLOCATE (WORK)

!
      END SUBROUTINE RACUN
   
!!!  Calculate value of UP function in the arbitrary points

      SUBROUTINE UPTURBOX(M)
  
       
real(8) UN,FAK,UNN,UN0,SUMAK,FUP_00,ZERO
COMMON FUP_00(0:131072, 0:1)
      DIMENSION UN(0:20),FAK(0:20),UNN(0:20),UN0(0:20)
      INTEGER(4) M,N,L,I,K
      
DATA UN0/1.0D0, 1.0D0, 5.0D0, 1.0D0, 143.0D0, 19.0D0, 1153.0D0,&
      583.0D0,1616353.0D0,132809.0D0, 134926369.0D0, 46840699.0D0,&
      67545496213157.0D0,4068990560161.0D0,411124285571171.0D0,&
      1204567303451311.0D0,73419800947733963069.0D0,&
      4146897304424408411.0D0,86773346866163284480799923.0D0,&
      18814360006695807527868793.0D0,&
      539741515875650532056045666422369.0D0/
!!!
      DATA UNN/1.0D0, 2.0D0, 72.0D0, 288.0D0, 2073600.0D0,&
      33177600.0D0, 561842749440.0D0, 179789679820800.0D0,&
      704200217922109440000.0D0, 180275255788060016640000.0D0,&
      1246394851358539387238350848000.0D0,&
      6381541638955721662660356341760000.0D0,&
      292214732887898713986916575925267070976000000.0D0,&
      1196911545908833132490410294989893922717696000000.0D0,&
      17524030168305511965050671651660013242599473361715200000.0D0,&
     15791254065263462941946461238743871133171237435708801024000000.0D0,&
626048168100066478643636623385103067560649311175417997219699097600000000.0D0,&
48488455061807039788823800613832680933046479303954410932297509162188800000000.0D0,  &
2924907327984663493179931480281060829152039746976389598046631610524565901849531514880000000.0D0,  &
3833734532936058133780799789833992049986161537156893373951680984546759018872217947183513600000000.0D0,  &
1391026453346497029228605426710671587340398341822365591105864134203768975246595308345805415518935449600000000000.0D0/
!!!
      DATA FAK/1.0D0,1.0D0,2.0D0,6.0D0,24.0D0,120.0D0,720.0D0,5040.0D0, &
          40320.0D0,362880.0D0,3628800.0D0,39916800.0D0,479001600.0D0,  &
      6227020800.0D0,87178291200.0D0,1307674368000.0D0,&
      20922789888000.0D0,355687428096000.0D0,6402373705728000.0D0,&
      121645100408832000.0D0,2432902008176640000.0D0/
!!!
      DATA ZERO/0.0D0/

           I = 0
        DO I = 0,M
                    UN(I) = UN0(I)/UNN(I)
FAK(I)= 2.0D0**((I*(I+1))/2)/FAK(I)
        END DO 

                  FUP_00  = 0.0D0
 FUP_00(1,0) = UN(M)
FUP_00(2,0) = UN(M-1)

 N = 1
 DO N = 1,M 
K = 2**N                      
 DO K = 2**N,2**(N+1)
                          SUMAK = ZERO
                                         L = 0
                                      DO L = 0,M-N 
           SUMAK = SUMAK + FAK(L)*UN(M-N-L)*(2.0D0**(-M)*(K-2**N))**L
                                      END DO
                                      FUP_00(K, 0) = SUMAK - FUP_00(K-2**N, 0)
                          END DO
                  END DO
		  
		  
		  
DO K = 0, 65536
                         FUP_00(K,1) = 2.0*FUP_00(2*K,0)
                         FUP_00(K+65536,1) = -FUP_00(K,1)
END DO 
 
     END SUBROUTINE UPTURBOX



    real(8) FUNCTION FUPN(NFUP, VERTEX, XPOINT, DELTAX, KOD)
	 
                      
    INTEGER(4) ::  NFUP,KOD
real(8)    ::  VERTEX, XPOINT, DELTAX

    SELECT CASE (NFUP)

    CASE ( 0)
    FUPN = FUP00(VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 1)
    FUPN = FUP01(VERTEX, XPOINT, DELTAX, KOD)
CASE ( 2)
FUPN = FUP02(VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 3)    
FUPN = FUP03(VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 4)    
FUPN = FUP04(VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 5)    
FUPN = FUP05(VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 6)    
FUPN = FUP06(VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 7)    
FUPN = FUP07(VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 8)    
FUPN = FUP08(VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 9)    
FUPN = FUP09(VERTEX, XPOINT, DELTAX, KOD)
    CASE (10)    
FUPN = FUP10(VERTEX, XPOINT, DELTAX, KOD)
    CASE (11)    
FUPN = FUP11(VERTEX, XPOINT, DELTAX, KOD)
    CASE (12)    
FUPN = FUP12(VERTEX, XPOINT, DELTAX, KOD)
    CASE (13)    
FUPN = FUP13(VERTEX, XPOINT, DELTAX, KOD)
    CASE (14)    
FUPN = FUP14(VERTEX, XPOINT, DELTAX, KOD)
    CASE (15)    
FUPN = FUP15(VERTEX, XPOINT, DELTAX, KOD)
    CASE (16)    
FUPN = FUP16(VERTEX, XPOINT, DELTAX, KOD)
    END SELECT

    END FUNCTION FUPN



    real(8) FUNCTION FUP00(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, INDEX, DVANF, KOD
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD=0, 1  -  indeks reda trazene derivacije 
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 0
   DVANF = 65536     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP00 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP00 = FUP_00(INDEX, KOD)
   END IF
   END FUNCTION FUP00




    real(8) FUNCTION FUP01(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1 
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 1
   DVANF = 32768     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP01 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP01 = FUP_01(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP01




    real(8) FUNCTION FUP02(VERTEX, XPOINT, DELTAX, KOD)
	 
INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2 
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 2
   DVANF = 16384     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY) .GE.  float((DVANF*(NFUP+2)/2))) THEN
              FUP02 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP02 = FUP_02(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP02




    real(8) FUNCTION FUP03(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2,3
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 3
   DVANF = 8192     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP03 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP03 = FUP_03(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP03





    real(8) FUNCTION FUP04(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2,3,4
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 4
   DVANF = 4096     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP04 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP04 = FUP_04(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP04


    real(8) FUNCTION FUP05(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2,3,4,5
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 5
   DVANF = 2048     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP05 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP05 = FUP_05(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP05


    real(8) FUNCTION FUP06(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2,3,4,5,6
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 6
   DVANF = 1024     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP06 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP06 = FUP_06(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP06


    real(8) FUNCTION FUP07(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2,3,4
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 7
   DVANF = 512     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP07 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP07 = FUP_07(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP07


    real(8) FUNCTION FUP08(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2, ... ,7,8
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 8
   DVANF = 256     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP08 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP08 = FUP_08(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP08


    real(8) FUNCTION FUP09(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2, ... ,9
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 9
   DVANF = 128     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP09 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP09 = FUP_09(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP09


    real(8) FUNCTION FUP10(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2, ... ,10
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 10
   DVANF = 64     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP10 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP10 = FUP_10(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP10


    real(8) FUNCTION FUP11(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2, ... ,11
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 11
   DVANF = 32     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP11 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP11 = FUP_11(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP11

    real(8) FUNCTION FUP12(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1, ... ,12
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 12
   DVANF = 16     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP12 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP12 = FUP_12(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP12


    real(8) FUNCTION FUP13(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1, ... ,13
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 13
   DVANF =  8     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP13 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP13 = FUP_13(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP13


    real(8) FUNCTION FUP14(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2, ... ,14
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 14
   DVANF =  4     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP14 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP14 = FUP_14(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP14


    real(8) FUNCTION FUP15(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2, ... ,15
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 15
   DVANF =  2   !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP15 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP15 = FUP_15(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP15


    real(8) FUNCTION FUP16(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2, ... ,16
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 16
   DVANF =  1     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP16 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP16 = FUP_16(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP16



END MODULE FUP_0_16_D    


Module GlobalData
Implicit None

Public

!!!   Boundary curves:
!!!   Written by: Hrvoje Gotovac, 2024.

!!!   Type_Boundary_curves -  0  -->  parametric
!!!                        -  1  -->  Fup2 or Fup4
!!!                        -  2  -->  B3-spline
!!!   BF_ORDER_BC - Order of basis functions for 1-D Boundary_curves	 
!!!   N_ext_BC - number of 1-D external boundary curves
!!!   N_cp_ext_BC - array that defines number of control points and basis functions 
!!!   for each of 1-D external boundary curves
!!!   X_cp_ext_BC; Y_cp_ext_BC - array of control points for 1-D external boundary curves
!!!   NPOT_ext_BC - array that defines number of basis functions for 1-D external boundary curves
!!!   DT_ext_BC - characteristic length for 1-D external boundary curves in parametric domain
!!!   XT_ext_BC - array of vertex coordinates for 1-D external boundary curves in parametric domain


!!!    Input Grid: 
!!!    XGrid0, Ygrid0 - Coordinates of grid origin
!!!    DeltaX, DeltaY - dx, dy are grid distances between vertices
!!!    NPOX, NPOY - number of vertices in each directions

!!!    Output: 
!!!    IJ_Point - integer 2-D field containing indexes of vertices of basis functions 
!!!    X_Vert, Y_Vert - coordinates of vertices of basis functions
!!!    Type_BF - integer 2-D field containing type of basis functions
!!!              = 0 - out of domain and do not cut the boundary (Fup coefficients are zero)
!!!              = 1 - inside domain; related to internal collocation points
!!!              = 2 - out of domain, but cut the internal polygon; related to boundary conditions 
!!!              = 3 - out of domain, but cut the boundary; related to external basis functions   
!!!    IJ_CUT - integer 2-D field containing information is it origin of cut element (its non-zero 
!!!             value represents index of boundary curve 1,...,N_ext_BC) or not (0)       

!!!    NFUP_BF - Order of Fup basis functions
!!!    Type_Eq - integer 2-D field containing type of differential equation (0,...6)
!!!    CC  - 2-D field containing values of Fup coefficients
!!!    RHS - 2-D field containing values of right hand side
    

!!!   Boundary conditions in 0-D entities; i = 1, N_ext_BC

!!!	   XPoint_0D(i,3)
!!!	   YPoint_0D(i,3) 
!!!	   Type_Eq_0D(i,3) 
!!!    Normal_x_0D(i,3)
!!!    Normal_y_0D(i,3)
!!!    Tangent_x_0D(i,3)
!!!    Tangent_y_0D(i,3)
!!!   Note if Type_Eq_0D=6, the both tangents are written as one tangent and one normal
!!!    C_index_0D(i,3,k) - k=1,(NFUP_BF+2)**2; Global Indexes of Fup coefficients
!!!    RHS_0D - field containing values of right hand side


!!!   Boundary conditions on cut elements:
!!!   Type_BC(i) - Type of boundary conditions; i = 1,N_ext_BC 
!!!              = 3 - Dirichlet
!!!              = 4 - Neumann
!!!   BC_Value(i) - value of Dirichlet or Neumann condition
!!!   Type_Eq_BC(i) Type of differential equations; i = 1,N_ext_BC
!!!   NPOINT_BC(i); i = 1, N_ext_BC
!!!   XPOINT_BC(i,j) - array of boundary coordinates;  i = 1,N_ext_BC, j= 1, NPOINT_BC(i)
!!!   YPOINT_BC(i,j) - array of boundary coordinates;  i = 1,N_ext_BC, j= 1, NPOINT_BC(i)
!!!   Normal_x_BC(i,j)
!!!   Normal_y_BC(i,j)
!!!   Tangent_x_BC(i,j)
!!!   Tangent_y_BC(i,j)
!!!   RHS_BC - 2-D field containing values of right hand side
!!!   C_index_BC(i,j,k) - k=1,(NFUP_BF+2)**2; Global Indexes of Fup coefficients
!!!   NP_CUT - 2-D array containing number of internal collocation pšoints on cut element (1-4)
!!!   Type_CUT_BC(i,j)
!!!   NCUT - number of cut elements

!!!   Number of points for all types of basis functions:


!!!	   NPOINT_TOT - Number of total basis functions
!!!    NPOINT_EQ - Number of Type_Eq =1 or 2; differential equation
!!!	   NPOINT_BC_TOT - Number of total boundary conditions: Type_BF=2 
!!!	   NPOINT_EX - Number of external basis functions: Type_BF=3
!!!    NPOINT_OUT - Number of vanishing basis functions: Type_BF=0, Type_Eq=0


!!!   Rubne vanjske krivulje:

!!!   Tip_rubne krivulje   -  0  -->  parametric
!!!                        -  1  -->  Fup2 or Fup4
!!!                        -  2  -->  B3-spline
!!!   BF_ORDER_BC - Red bazne funkcije za 1-D vanjske rubne krivulje
!!!   N_ext_BC - broj 1-D vanjskih rubnih kruvulja
!!!   N_cp_ext_BC - polje koje definira broj kontrolnih točaka za svaku 1-D krivulju
!!!   X_cp_ext_BC; Y_cp_ext_BC - polje koordinata kontrolnih točaka 
!!!   NPOT_ext_BC - polje koje definira broj baznih fukcija za ips svih 1-D vanjskih rubnih krivulja
!!!   DT_ext_BC - duljina karakterističnog nosača za 1-D vanjske rubne krivulje u parametarskoj domeni (0,1)
!!!   XT_ext_BC - koordinate tjemena b.f-ja za 1-D vanjske rubne krivulje u parametarskoj domeni (0,1)


!!!    Input Grid: 
!!!    XGrid0, Ygrid0 - Koordinate ishodista osnovnog grida
!!!    DeltaX, DeltaY - dx, dy je disretizacija osnovnog grida u oba smjera
!!!    NPOX, NPOY - broj b.f-ja u oba smjera

!!!    Output: 
!!!    IJ_Point - integer 2-D polje koje sadrzi indekse b.f-ja 
!!!    X_Vert, Y_Vert - koordinate tjemena b.f-ja u osnovnom gridu
!!!    Type_BF - integer 2-D polje koje sadrzi tipove b.f-ja
!!!              = 0 - van domene i ne siječe granicu (Fup coeficijenti su nula)
!!!              = 1 - unutar domene; vezano za unutrasnje b.f-je i kolokacijske točke u kojima se pise dif. jedn.
!!!              = 2 - van domene, ali siječe unutrasnji upisani poligon i ove b.f-jr su vezane sa zadavanjem rubnih uvjeta 
!!!              = 3 - van domene, ali siječe rub domene ; vezane za vanjske b.f-je ciji se koeficijenti nalaze u postprocesor koraku  
!!!    IJ_CUT - integer 2-D polje koje sadrži informaciju da li je to cut-element (ima vrijednost indeksa rubne krivulje) ili ne (onda je
!!!             vrijednost nula)
!!!    CC  - 2-D polje koje sadrži Fup coefficijente
!!!    RHS - 2-D polje koje sadrzi vrijednosti desne strane jednadžbe
           

!!!    NFUP_BF - Red za Fup basis functions
!!!    Type_Eq - integer 2-D polje čiji indeks kaze koji tip jednadzbe se pise za koju b.f-ju (0,...6)
    

!!!   Rubni uvjeti u 0-D entitetima, tj. kranjim točka vanjskih rubnih krivulja; i = 1, N_ext_BC

!!!	   XPoint_0D(i,3)
!!!	   YPoint_0D(i,3) 
!!!	   Type_Eq_0D(i,3) 
!!!    Normal_x_0D(i,3)
!!!    Normal_y_0D(i,3)
!!!    Tangent_x_0D(i,3)
!!!    Tangent_y_0D(i,3)
!!!   Napomena ako je Type_Eq_0D=6 onda su obje tangente napisane na mjestu normale i tangente
!!!    C_index_0D(i,3,k) - k=1,(NFUP_BF+2)**2; Globalni indeksi Fup koeficijenta na pripadnom cut elementu
!!!    RHS_0D - 2-D polje koje sadrzi vrijednosti desne strane jednadžbe


!!!   Rubni uvjeti za cut elemente:
!!!   Type_BC(i) - Tip rubnog uvjeta; i = 1,N_ext_BC 
!!!              = 3 - Dirichlet
!!!              = 4 - Neumann
!!!   BC_Value(i) - vrijednost za Dirichlet or Neumann rubni uvjet
!!!   Type_Eq_BC(i) - Tip diferencijalne jednadzbe; i = 1,N_ext_BC
!!!   NPOINT_BC(i); i = 1, N_ext_BC->broj rubnih uvjeta za svaku rubnu krivulju
!!!   XPOINT_BC(i,j) - x-koordinate rubnih točaka u kojima se uzima vrijednost rubnog uvjeta;  i = 1,N_ext_BC, j= 1, NPOINT_BC(i)
!!!   YPOINT_BC(i,j) - y-koordinate rubnih točaka u kojima se uzima vrijednost rubnog uvjeta;  i = 1,N_ext_BC, j= 1, NPOINT_BC(i)
!!!   Normal_x_BC(i,j)
!!!   Normal_y_BC(i,j)
!!!   Tangent_x_BC(i,j)
!!!   Tangent_y_BC(i,j)
!!!   RHS_BC - 2-D polje koje sadrzi vrijednosti desne strane jednadžbe
!!!   C_index_BC(i,j,k) - k=1,(NFUP_BF+2)**2; Fup koeficijenta na pripadnom cut elementu
!!!   NP_CUT - 2-D integer polje koje sadrzi broj kolokacijskih točaka kije pripadaju unujtrasnjem poligonu pripadnom cut elementu (1-4)
!!!   Type_CUT_BC(i,j) - Tip cut elementa od 1 do 4 zavisno od kvadranta kojem pripada u lokalnom koordinantnom sustavu
!!!   NCUT - broj cut elementa

!!!   Broj svih tipova b.f-ja:


!!!	   NPOINT_TOT - Ukupan broj b.f-ja
!!!    NPOINT_EQ - Ukupan broj b.f-ja za: Type_Eq =1 or 2; differential equation
!!!	   NPOINT_BC_TOT - Ukupan broj b.f-ja za: Type_BF=2 
!!!	   NPOINT_EX - Ukupan broj vanjskih b.f-ja za:  Type_BF=3
!!!    NPOINT_OUT - Ukupan broj b.f-ja za: Type_BF=0, Type_Eq=0

      integer*4 BF_ORDER, N_ext_BC
      integer*4 N_cp_ext_BC(20), NPOT_ext_BC(20) 
      real*8    X_cp_ext_BC(20,50), Y_cp_ext_BC(20,50), DT_ext_BC(20), XT_ext_BC(20,50)


!!!    Input Grid: 
       real*8     XGrid0, Ygrid0, DeltaX, DeltaY 
       integer*4  NPOX, NPOY, NFUP_BF

!!!    Output: 
       integer*4 IJ_Point(0:2048,0:2048), Type_BF(0:2048,0:2048), IJ_CUT(0:2048,0:2048), Type_Eq(0:2048,0:2048) 
	   real*8    CC(0:2048,0:2048), RHS(0:2048,0:2048)
    

!!!   Boundary conditions in 0-D entities; i = 1, N_ext_BC

       real*8 XPoint_0D(20), YPoint_0D(20), Normal1_x_0D(20), Normal1_y_0D(20)
	   real*8 Normal2_x_0D(20), Normal2_y_0D(20), RHS_0D(20,3)
       integer*4  C_index_0D(20,3,64), Type_Eq_0D(20,3)



!!!   Boundary conditions on cut elements:


      integer*4  Type_BC(20), Type_Eq_BC(20), NPOINT_BC(20)
	  real*8     BC_Value(20), XPOINT_BC(20,4096), YPOINT_BC(20,4096), Normal_x_BC(20,4096), Normal_y_BC(20,4096)
	  real*8     Tangent_x_BC(20,4096), Tangent_y_BC(20,4096), RHS_BC(20,4096)
	  integer*4  C_index_BC(20,4096,64), NP_CUT(0:2048,0:2048), Type_CUT_BC(20,4096)

!!!   Number of points for all types of basis functions:

	  integer*4  NCUT, NPOINT_TOT, NPOINT_EQ, NPOINT_BC_TOT, NPOINT_EX, NPOINT_OUT 

End Module


!!!   Module Geometry creates 2-D background uniform grid related to the definition of 1-D 
!!!   external boundary curves.
!!!   Module defines all entites of 2-D grid: basis functions, vertices of basis functions or collocation points,
!!!   their coordinates, types, points and statistics of "cut elements", etc....
!!!   Modul Geometry generira 2-D jednoliki kolokacijski grid s obzirom na 1-D rubne vanjske krivulje
!!!   Modul definira sve entitete grida uključujući bazne f-je, tjemena b.f-ja ili kolokacijskih točaka,
!!!   njihove koordinate, tipove, statistiku "cut" elementa, itd...
!!!   Written by: Hrvoje Gotovac, 2024.

      Module Geometry  
	  
	  USE Fup_0_16_D
	  USE GlobalData
	  
 
	  
	  Contains
	  

!!!   This routine reads input data

     Subroutine Input
     
     
     integer(4) i,j
     
! Open the file for reading
     OPEN(1, FILE='SBFCM_Input.dat', STATUS='UNKNOWN') 
     
     
!!!  Definiraj osnovne geometrijske parametre
!!!  Red baznih f-ja, tip b-fija i broj rubnih krivulja
!!!  Define basic geometric parameters
!!!  Order of basis functions, type of basis functions and number of boundary curves
     
      read(1,*)  BF_ORDER
      read(1,*)  BF_Bcurves
      read(1,*)  N_ext_BC
      
!!!  i,  zadaj broj kontrolnih točaka po i-toj rubnoj krivulji
!!!  i,  define number of control points for i-th boundary curve

      do i = 1, N_ext_BC
      
      read(1,*)  N_cp_ext_BC(i)
      
 !!!  j,  zadaj kontrolne točke za i-tu rubnu krivulju
 !!!  j,  define control points for i-th boundary curve 
 
      do j = 1, N_cp_ext_BC(i)
      read(1,*) X_cp_ext_BC(i,j), Y_cp_ext_BC(i,j)
      end do  !!!  j
      
      end do  !!!  i,  po rubnim krivuljama/over boundary curves
      

!!!    Input 2-D Grid for solution approximation:
 
       read(1,*)    XGrid0, Ygrid0, DeltaX, DeltaY 
       read(1,*)    NPOX, NPOY, NFUP_BF


!!!   Boundary conditions on boundary curves
!!!   Rubni uvjeti na rubnim krivuljama (tip i vrijednost)

      do i = 1, N_ext_BC
      read(1,*) Type_BC(i), BC_Value(i)
      end do   
     
     
     End Subroutine Input




!!!   Creates parameters for 1-D external boundary curves
!!!   Generira parametre za 1-D vanjske rubne krivulje
!!!   Input:  X_i; Y_i; control points
!!!   Output: Functions which define 1-D boundary curves


	  Subroutine Boundary_curves
	  
!!!   Type_Boundary_curves
!!!   BF_Bcurves           -  0  -->  parametric
!!!                        -  1  -->  Fup2 or Fup4 (only Fup2 work for now)
!!!                        -  2  -->  B3-spline
!!!   BF_ORDER_BC - Order of basis functions for 1-D Boundary_curves	 
!!!   N_ext_BC - number of 1-D external boundary curves
!!!   N_cp_ext_BC - array that defines number of control points and basis functions for 1-D external boundary curves
!!!   X_cp_ext_BC; Y_cp_ext_BC - array of control points for 1-D external boundary curves
!!!   NPOT_ext_BC - array that defines number of basis functions for 1-D external boundary curves
!!!   DT_ext_BC - characteristic length for 1-D external boundary curves in parametric domain
!!!   XT_ext_BC - array of vertex coordinates for 1-D external boundary curves in parametric domain

      Integer(4)   i,j
      
             
!!!   Define parameters for external 1-D boundary curves

       do i = 1, N_ext_BC
	   if (BF_Bcurves.ne.0) then
       if (BF_Bcurves.eq.1) NPOT_ext_BC(i) = N_cp_ext_BC(i) - BF_ORDER_BC - 1
       if (BF_Bcurves.eq.2) NPOT_ext_BC(i) = N_cp_ext_BC(i) - BF_ORDER_BC
	   DT_ext_BC(i) = 1.0d0 / NPOT_ext_BC(i)
       do j = -BF_ORDER_BC/2, NPOT_ext_BC(i) + BF_ORDER_BC/2
       XT_ext_BC(i,j) = DT_ext_BC(i)*dfloat(j)
       end do
       end if
       end do

 
       
       end Subroutine 
       

!!!   Routine calculates xy-point value in real physical x-y domain of 1-D external boundary curves
!!!   with respect to parametric coordinates tt->(0,1)
!!!   Rutina racuna x-y vrijednosti tocke za vanjske rubne krivulje s obzirom na njene parametarske
!!!   koordinate tt->(0,1) 

	  Subroutine BCurve_value(icurve,tt,xpoint,ypoint)
      
      real(8) tt,xpoint,ypoint,ft1
      integer(4) icurve, ITC, TK
      
      xpoint = -9999.99d0
      ypoint = -9999.99d0
      if (tt.lt.0.0d0.or.tt.gt.1.0d0) return
      xpoint = 0.0d0
      ypoint = 0.0d0
      
      TK = INT4(tt / DT_ext_BC(icurve))

      DO ITC = TK - BF_ORDER_BC/2, TK + BF_ORDER_BC/2 + 1


	  IF (ITC.LT.-BF_ORDER_BC/2.OR.ITC.GT.NPOT_ext_BC(icurve) + BF_ORDER_BC/2) CYCLE 

      if (ITC.eq.-1) then
      ft1 = (36.0d0/5.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),0)
      else if (ITC.eq.0) then
      ft1 = (-36.0d0/5.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC-1),tt,DT_ext_BC(icurve),0) + &
            (18.0d0/13.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),0)
      else if (ITC.eq.1) then
      ft1 =                 FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC-2),tt,DT_ext_BC(icurve),0) + &
            (-5.0d0/13.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC-1),tt,DT_ext_BC(icurve),0) + &
                            FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),0)
      else if (ITC.eq.NPOT_ext_BC(icurve) + 1) then
      ft1 = (36.0d0/5.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),0)
      else if (ITC.eq.NPOT_ext_BC(icurve)) then
      ft1 = (-36.0d0/5.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC+1),tt,DT_ext_BC(icurve),0) + &
            (18.0d0/13.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),0)
      else if (ITC.eq.NPOT_ext_BC(icurve) - 1) then
      ft1 =                 FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC+2),tt,DT_ext_BC(icurve),0) + &
            (-5.0d0/13.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC+1),tt,DT_ext_BC(icurve),0) + &
                            FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),0)
      else
      ft1 = FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),0)
      end if
                            
                                                  
      xpoint = xpoint + X_cp_ext_BC(icurve,ITC)  *  ft1
	           
      ypoint = ypoint + Y_cp_ext_BC(icurve,ITC)  *  ft1
	                                      
   
 
      END DO  !!!  ITC
	

      
      End Subroutine
      
!!!   Routine calculates tangent value in real physical x-y domain of 1-D external boundary curves
!!!   with respect to parametric coordinates tt->(0,1)
!!!   Rutina racuna tangentu u realnim x-y koordinatama za vanjske rubne krivulje s obzirom na 
!!!   njene parametarske koordinate tt->(0,1) 

	  Subroutine BCurve_tangent(icurve,tt,t_x,t_y)
      
      real(8) tt,t_x,t_y,ft1,length_t
      integer(4) icurve, ITC, TK
      
      t_x = -9999.99d0
      t_y = -9999.99d0
      if (tt.lt.0.0d0.or.tt.gt.1.0d0) return
      t_x = 0.0d0
      t_y = 0.0d0
      
      TK = INT4(tt / DT_ext_BC(icurve))

      DO ITC = TK - BF_ORDER_BC/2, TK + BF_ORDER_BC/2 + 1


	  IF (ITC.LT.-BF_ORDER_BC/2.OR.ITC.GT.NPOT_ext_BC(icurve) + BF_ORDER_BC/2) CYCLE 

      if (ITC.eq.-1) then
      ft1 = (36.0d0/5.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),1)
      else if (ITC.eq.0) then
      ft1 = (-36.0d0/5.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC-1),tt,DT_ext_BC(icurve),1) + &
            (18.0d0/13.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),1)
      else if (ITC.eq.1) then
      ft1 =                 FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC-2),tt,DT_ext_BC(icurve),1) + &
            (-5.0d0/13.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC-1),tt,DT_ext_BC(icurve),1) + &
                            FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),1)
      else if (ITC.eq.NPOT_ext_BC(icurve) + 1) then
      ft1 = (36.0d0/5.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),1)
      else if (ITC.eq.NPOT_ext_BC(icurve)) then
      ft1 = (-36.0d0/5.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC+1),tt,DT_ext_BC(icurve),1) + &
            (18.0d0/13.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),1)
      else if (ITC.eq.NPOT_ext_BC(icurve) - 1) then
      ft1 =                 FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC+2),tt,DT_ext_BC(icurve),1) + &
            (-5.0d0/13.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC+1),tt,DT_ext_BC(icurve),1) + &
                            FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),1)
      else
      ft1 = FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),1)
      end if
                            
                           
      t_x = t_x + X_cp_ext_BC(icurve,ITC)  *  ft1
	           
      t_y = t_y + Y_cp_ext_BC(icurve,ITC)  *  ft1
	  
  
 
      END DO  !!!  ITC
	
	  length_t = dsqrt(t_x**2+t_y**2)
	  
	  t_x = t_x / length_t
	  t_y = t_y / length_t	  
	                                      
 
      
      End Subroutine
      
!!!   Routine calculates normal value in real physical x-y domain of 1-D external boundary curves
!!!   with respect to parametric coordinates tt->(0,1)
!!!   Rutina racuna normalu u realnim x-y koordinatama za vanjske rubne krivulje s obzirom na 
!!!   njene parametarske koordinate tt->(0,1) 

	  Subroutine BCurve_normal(icurve,tt,n_x,n_y)
      
      real(8) tt,t_x,t_y,n_x,n_y,ft1,length_t
      integer(4) icurve, ITC, TK
      
      t_x = -9999.99d0
      t_y = -9999.99d0
      if (tt.lt.0.0d0.or.tt.gt.1.0d0) return
      t_x = 0.0d0
      t_y = 0.0d0
      
      TK = INT4(tt / DT_ext_BC(icurve))

      DO ITC = TK - BF_ORDER_BC/2, TK + BF_ORDER_BC/2 + 1


	  IF (ITC.LT.-BF_ORDER_BC/2.OR.ITC.GT.NPOT_ext_BC(icurve) + BF_ORDER_BC/2) CYCLE 

      if (ITC.eq.-1) then
      ft1 = (36.0d0/5.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),1)
      else if (ITC.eq.0) then
      ft1 = (-36.0d0/5.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC-1),tt,DT_ext_BC(icurve),1) + &
            (18.0d0/13.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),1)
      else if (ITC.eq.1) then
      ft1 =                 FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC-2),tt,DT_ext_BC(icurve),1) + &
            (-5.0d0/13.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC-1),tt,DT_ext_BC(icurve),1) + &
                            FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),1)
      else if (ITC.eq.NPOT_ext_BC(icurve) + 1) then
      ft1 = (36.0d0/5.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),1)
      else if (ITC.eq.NPOT_ext_BC(icurve)) then
      ft1 = (-36.0d0/5.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC+1),tt,DT_ext_BC(icurve),1) + &
            (18.0d0/13.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),1)
      else if (ITC.eq.NPOT_ext_BC(icurve) - 1) then
      ft1 =                 FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC+2),tt,DT_ext_BC(icurve),1) + &
            (-5.0d0/13.0d0)*FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC+1),tt,DT_ext_BC(icurve),1) + &
                            FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),1)
      else
      ft1 = FUPN(BF_ORDER_BC,XT_ext_BC(icurve,ITC),tt,DT_ext_BC(icurve),1)
      end if
                            
                           
      t_x = t_x + X_cp_ext_BC(icurve,ITC)  *  ft1
	           
      t_y = t_y + Y_cp_ext_BC(icurve,ITC)  *  ft1
	  
      END DO  !!!  ITC
	
	  length_t = dsqrt(t_x**2+t_y**2)
	  
	  t_x = t_x / length_t
	  t_y = t_y / length_t	  
	                                      
      n_x = - t_y
	  n_y =   t_x 
 

      
      End Subroutine
      
                 
       

!!!  Create 2-D grid and all entities related to basis functions, its types and vertices, statistics of 
!!!  cut elements, collocation points, boundary points, etc...
!!!  Formiranje 2-D grida sa svim entitetima baznih funkcija, njihovih tjemena, koordinata,
!!!  kolokacijskih točaka, rubnih točaka, statistike "cut" elemenata, itd....


       Subroutine Grid2D

!!!    Input: 
!!!    XGrid0, Ygrid0 - Coordinates of grid origin
!!!    DeltaX, DeltaY - dx, dy are grid distances between vertices
!!!    NPOX, NPOY - number of vertices in each directions

!!!    Output: 
!!!    IJ_Point - integer 2-D field containing indexes of vertices of basis functions 
!!!    XVert, YVert - coordinates of vertices of basis functions
!!!    Type_BF - integer 2-D field containing type of basis functions
!!!              = 0 - out of domain and do not cut the boundary (Fup coefficients are zero)
!!!              = 1 - inside domain; related to internal collocation points
!!!              = 2 - out of domain, but cut the internal polygon; related to boundary conditions 
!!!              = 3 - out of domain, but cut the boundary; related to external basis functions   
!!!    IJ_CUT - integer 2-D field containing information is it origin of cut element (its non-zero value represents 
!!!             index of boundary curve 1,...,N_ext_BC) or not (0)       


!!!    Create 2-D integer field for 2-D grid
!!!    Formiraj 2-D cjelobrojno polje za 2-D grid

       Integer(4)  i,j,k,IK,JK,k,kk,k1,k2,k3,k4,k5,ind,ind1,ind2,ind3
       Real(8)  XPOINT1,YPOINT1,XPOINT2,YPOINT2,tt,tt_old,tt_new

       k = 0
	   do i=0, NPOX
	   do j=0, NPOY
	   k = k + 1
	   IJ_Point(i,j) = k
	   Type_BF(i,j) = 0   !!!  All types of basis functions are initially zero
	   IJ_CUT(i,j)  = 0   !!!  All basis functions initially do not belong to the cut elements
	   X_Vert(i,j) = XGrid0 + dfloat(i)*DeltaX
	   Y_Vert(i,j) = YGrid0 + dfloat(j)*DeltaY
	   end do
	   end do
	   
!!!    Find number of cut elements: NCUT
!!!    Find all related four vertices on cut element and its types (1 or 2)	   
!!!    Nadji broj "cut" elemenata
!!!    Nadji sva četiri tjemena na "cut" elementu  i njihove tipove (1 or 2)
!!!    Algorithm; Travel over all external boundary curves from 0 to 1 in parametric coordinates and check 
!!!    which "cut" elements correspond to the current point, step should be less than
!!!    max(DeltaX/10, DeltaY/10) in real coordinates   
!!!    Algoritam; Putuj svim rubnim vanjskim krivuljama od 0 do 1 u parametarskim koordinata i ispitivaj 
!!!    na kojem je trenutna točka "cut" elementu, korak mora biti manji od 
!!!    max(DeltaX/10, DeltaY/10) u fizikalnim stvarnim koordinatama

!!!    Firstly check 0-D entites in each external boundary curve in the end parametric cordinates tt=1.0 
!!!    Prvo provjeri 0-D entitete, tj. krajnje točke svake vanjske rubne krivulje u parametarskim
!!!    koordinatama tt=1.0

	   
    
       do i = 1, N_ext_BC
	   
	   
!!!   Find end point -> 0-D entitity for each boundary curve
!!!   Nadji krajnju točku na svakoj rubnoj krivulji

       Call Bcurve_Value(i,1.0d0,XPOINT1,YPOINT1)
	   IK = int4((XPOINT1-XGrid0)/DeltaX)
	   JK = int4((YPOINT1-Ygrid0)/DeltaY)
	   
       
!!!    Find indexes of two boundary curves which have the current joint point - O-D entity
!!!    Nadji indekse dviju rubnih krivulja koje se sijeku u točki 0-D entiteta

       k1 = i
       if (i.lt.N_ext_BC) then
       k2 = i + 1
       else
       k2 = 1
       end if
       
!!!    Find data for boundary conditions on the first boundary curve - k1
!!!    Nadji rubne uvjete za prvu krivulju k1

	   XPoint_0D(i) = XPOINT1 - X_Vert(IK,JK)
	   YPoint_0D(i) = YPOINT1 - Y_Vert(IK,JK)
	   Type_Eq_0D(i,1) = Type_BC(k1)
       RHS_0D(i,1) = BC_Value(k1)
       if (Type_BC(k1).eq.4) then
       Call Bcurve_Normal(k1,1.0d0,XPOINT1,YPOINT1,n_x,n_y)
       Normal1_x_0D(i,1)=n_x
       Normal1_y_0D(i,1)=n_y
       end if
       
!!!    Find data for boundary conditions on the second boundary curve - k2
!!!    If both Dirichlet boundary conditions exist on k1 and k2, then write
!!!    tangent equation for k1 (Type_Eq=5)
!!!    If there are two different Dirichlet values on k1 and k2, find then 
!!!    arithmetic mean analougly with Fourier analysis
!!!    Nadji rubne uvjete za drugu krivulju k2
!!!    Ako su obje krivulje s Dirichletovim rubnim uvjetom, pisi tangentnu jedn. za k1 (Type_Eq=5)
!!!    Ako su različite vrijednosti za Dirichletov rubni uvjet na k1 i k2, onda nadji srednju vrijednost,
!!!    kao sto se radi u Fourierovoj analizi


 	   if ((Type_BC(k1).eq.3).and.(Type_BC(k2).eq.3)) Then
       Type_Eq_0D(i,2) = 5
       RHS_0D(i,1) = (BC_Value(k1)+BC_Value(k2))/2.0d0
       RHS_0D(i,2) = 0.0d0
       Call Bcurve_Normal(k1,1.0d0,XPOINT1,YPOINT1,n_x,n_y)
       Normal1_x_0D(i,2)=n_x
       Normal1_y_0D(i,2)=n_y      
       else
	   Type_Eq_0D(i,2) = Type_BC(k2)
       RHS_0D(i,2) = BC_Value(k2)
       if (Type_BC(k2).eq.4) then
       Call Bcurve_Normal(k2,0.0d0,XPOINT1,YPOINT1,n_x,n_y)
       Normal1_x_0D(i,2)=n_x
       Normal1_y_0D(i,2)=n_y
       end if
     
!!!   Find data for additional boundary conditions in the 0-D point

!!!   Case 1: Dirichlet - k1 and k2

       if ((Type_BC(k1).eq.3).and.(Type_BC(k2).eq.3)) Then
       Call Bcurve_Normal(k2,0.0d0,XPOINT1,YPOINT1,n_x1,n_y1)
       Call Bcurve_Normal(k1,1.0d0,XPOINT1,YPOINT1,n_x2,n_y2)
       Type_Eq_0D(i,3) = 6 
       RHS_0D(i,3) = 0.0d0
       Normal1_x_0D(i,3)=n_x1
       Normal1_y_0D(i,3)=n_y1
       Normal2_x_0D(i,3)=n_x2
       Normal2_y_0D(i,3)=n_y2
       end if

!!!   Case 2: Dirichlet - k1 and Neumann - k2 
       
       if ((Type_BC(k1).eq.3).and.(Type_BC(k2).eq.4)) Then
       Call Bcurve_Normal(k2,0.0d0,XPOINT1,YPOINT1,n_x1,n_y1)
       Call Bcurve_Normal(k1,1.0d0,XPOINT1,YPOINT1,n_x2,n_y2)
       Type_Eq_0D(i,3) = 7 
       RHS_0D(i,3) = 0.0d0
       Normal1_x_0D(i,3)=n_x1
       Normal1_y_0D(i,3)=n_y1
       Normal2_x_0D(i,3)=n_x2
       Normal2_y_0D(i,3)=n_y2
       end if
       
!!!   Case 3: Neumann - k1 and Dirchlet - k2 
       
       if ((Type_BC(k1).eq.4).and.(Type_BC(k2).eq.3)) Then
       Call Bcurve_Normal(k2,0.0d0,XPOINT1,YPOINT1,n_x2,n_y2)
       Call Bcurve_Normal(k1,1.0d0,XPOINT1,YPOINT1,n_x1,n_y1)
       Type_Eq_0D(i,3) = 7 
       RHS_0D(i,3) = 0.0d0
       Normal1_x_0D(i,3)=n_x1
       Normal1_y_0D(i,3)=n_y1
       Normal2_x_0D(i,3)=n_x2
       Normal2_y_0D(i,3)=n_y2
       end if
       
!!!   Case 4: Neumann - k1 and Neumann - k2 
       
       if ((Type_BC(k1).eq.4).and.(Type_BC(k2).eq.4)) Then
       Call Bcurve_Normal(k2,0.0d0,XPOINT1,YPOINT1,n_x2,n_y2)
       Call Bcurve_Normal(k1,1.0d0,XPOINT1,YPOINT1,n_x1,n_y1)
       Type_Eq_0D(i,3) = 8 
       RHS_0D(i,3) = 0.0d0
       Normal1_x_0D(i,3)=n_x1
       Normal1_y_0D(i,3)=n_y1
       Normal2_x_0D(i,3)=n_x2
       Normal2_y_0D(i,3)=n_y2      
	   end if
                     

       end do   !!!  i = 1, N_ext_BC
       
       
!!!    Algorithm; Travel over all boundary curves from 0 to 1 in parametric coordinates and check 
!!!    which "cut" elements corresponding to the current point, step should be less than
!!!    max(DeltaX/10, DeltaY/10) in real coordinates   
!!!    Algoritam; Putuj svim rubnim krivuljama od 0 do 1 u parametarskim koordinata i ispitivaj 
!!!    na kojem je "cut" elementu trenutna točka, korak mora biti manji od 
!!!    max(DeltaX/10, DeltaY/10) u fizikalnim stvarnim koordinatama

	   do i = 1, N_ext_BC
	   NPOINT_BC(i) = 0
       end do
       NCUT = 0
       
       do i = 1, N_ext_BC
	   tt = 0.0d0
       tt_old = 0.0d0
       Call Bcurve_Value(i,tt,XPOINT1,YPOINT1)
	   IK = int4((XPOINT1-XGrid0)/DeltaX)
	   JK = int4((YPOINT1-Ygrid0)/DeltaY)
	   write(1,*) XPOINT1,YPOINT1
	   if (IJ_CUT(IK,JK).eq.0) then
       IJ_CUT(IK,JK) = i
           IK_CUT(NCUT) = IK
           JK_CUT(NCUT) = JK
           NCUT = NCUT + 1
           NP_CUT(IK,JK) = NCUT
       end if
       dt = 1.0d0/50.0d0
       dd = DMAX1(DeltaX,DeltaY)
       IK_OLD = IK
       JK_OLD = JK

!!!   Adjust initial step in each curve in parametric coordinates that actual physical step is less than 
!!!   max(DeltaX/10,Delt aY/10)
!!!   Pronadji početni parametarski korak na svakoj rubnoj krivulji da on u stvarnim koordinatama bude manji od
!!!   max(DeltaX/10,DeltaY/10)


  
      do while (dd.gt.DeltaX/10.0d0.or.dd.gt.DeltaY/10.0d0)
           dt = dt/2.0d0
           Call Bcurve_Value(i,tt+dt,XPOINT2,YPOINT2)
	   IK = int4((XPOINT2-XGrid0)/DeltaX)
	   JK = int4((YPOINT2-Ygrid0)/DeltaY)
           dd = Distance(XPOINT1,YPOINT1,XPOINT2,YPOINT2)
       end do  !!!  while
       
       tt = tt + dt
       
!!!   Continue to the end of the current boundary curve, from tt=0 to tt=1       
!!!   Nastavi do kraja tekuće rubne krivulje, od tt=0 do tt=1 


       do while (tt.le.1.0d0)
       
       Call Bcurve_Value(i,tt,XPOINT2,YPOINT2)
	   IK = int4((XPOINT2-XGrid0)/DeltaX)
	   JK = int4((YPOINT2-Ygrid0)/DeltaY)

!!!    Check if curve tracker crosses the next cut element, denotes ell neigbours elements 
!!!    also as potential cut elements
!!!    Provjeri da li je trenutna točka na rubnoj krivulji presla na drugi "cut" element
!!!    Oznaci i sve susjedne elemente kao potencijalne "cut" elemente

	   if (IK.ne.IK_OLD.or.JK.ne.JK_OLD) then
 
          do k1 = IK-1,IK+1
           do k2 = JK-1,JK+1
           if (k1.lt.0.or.k1.gt.NPOX) cycle
           if (k2.lt.0.or.k2.gt.NPOY) cycle
           if (IJ_CUT(k1,k2).eq.0) then
           IJ_CUT(k1,k2) = i
           NCUT = NCUT + 1
           NP_CUT(k1,k2) = NCUT
           IK_CUT(NCUT) = k1
           JK_CUT(NCUT) = k2
           end if   !!!  IJ_CUT
           end do  !!! k2
          end do  !!! k1
           
           
!!!    Find exact cut inlet point S for new cut element
!!!    Nadji točnu ulaznu točku S za novi cut element

              
               dcut = 1.0d9
              XCUT1 = XGrid0 + dfloat(IK)*DeltaX
              XCUT2 = XCUT1 + DeltaX
              YCUT1 = YGrid0 + dfloat(JK)*DeltaY
              YCUT2 = YCUT1 + DeltaY
              
              CALL Find_cut_point(i,IK_OLD,JK_OLD,tt_old,IK,JK,tt,XCUT1,  &
                                  YCUT1,XCUT2,YCUT2,tt_new,XPOINT2,YPOINT2)
              
              tt = tt_new 
              

 	          dcut1 = dabs(XPOINT2-XCUT1)
              dcut2 = dabs(XPOINT2-XCUT2)
              dcut3 = dabs(YPOINT2-YCUT1)
              dcut4 = dabs(YPOINT2-YCUT2)
       
                    
              if (dcut1.le.eps_cut) then
              XPOINT2 = XCUT1
              IK1 = nint((XPOINT2-XGrid0)/DeltaX)
              NCUTx(IK1)=NCUTx(IK1)+1
              CutPointY(IK1,NCUTx(IK1)) = YPOINT2
              write(1,*) XPOINT2,YPOINT2
              end if
              
              if (dcut2.le.eps_cut) then
              XPOINT2 = XCUT2
              IK1 = nint((XPOINT2-XGrid0)/DeltaX)
              NCUTx(IK1)=NCUTx(IK1)+1
              CutPointY(IK1,NCUTx(IK1)) = YPOINT2
              write(1,*) XPOINT2,YPOINT2
              end if
              
              if (dcut3.le.eps_cut) then
              YPOINT2 = YCUT1
              JK1 = nint((YPOINT2-YGrid0)/DeltaY)
              NCUTy(JK1)=NCUTy(JK1)+1
              CutPointX(JK1,NCUTy(JK1)) = XPOINT2
              write(1,*) XPOINT2,YPOINT2
              end if
              
              if (dcut4.le.eps_cut) then
              YPOINT2 = YCUT2
              JK1 = nint((YPOINT2-YGrid0)/DeltaY)
              NCUTy(JK1)=NCUTy(JK1)+1
              CutPointX(JK1,NCUTy(JK1)) = XPOINT2
              write(1,*) XPOINT2,YPOINT2
              end if

              IK_OLD = IK
              JK_OLD = JK
         
       end if   !!!  (IK.ne.IK_OLD.or.JK.ne.JK_OLD) 
         
         tt_old = tt
         tt = tt + dt
         
       end do   !!!  while  (tt.le.1.0d0)
       
              
       end do   !!!  i = 1, N_ext_BC
       

!!!   Find all internal basis functions (TYPE_BF = 1); sum all intersections in positive vertical and 
!!!   horizontal direction for each point/vertex. If number of intersections in both directions are odd, 
!!!   then it is internal point or basis function. If vertex is equal to some cut point, it is boundary 
!!!   point (TYPE_BF = 2)
!!!   Nadji sve unutrašnje bazne funkcije i kolokacijske točke (TYPE_BF = 1); zbroji sva presjecista
!!!   grid linija u pozitivnom smislu i rubnih krivulja. Ako je broj sjecista neparan, tada je TYPE_BF = 1
!!!   Ako je neka cut tocka jednaka grid tocki onda je to istovremeno i rubna točka (TYPE_BF = 2)

       k = 0
	   do i=0, NPOX
	   do j=0, NPOY

       ind1 = 0
	   ind2 = 0
	   ind3 = 0
	   
	   do k1 = 1, NCUTx(i)
	   if (CutPointY(i,k1).lt.Y_Vert(i,j)) ind1 = ind1 + 1
	   if (dabs(CutPointY(i,k1)-Y_Vert(i,j))).le.eps_cut) ind3 = ind3 + 1
	   end do   !!! k1
	   
	   do k2 = 1, NCUTy(j)
	   if (CutPointX(j,k2).lt.X_Vert(i,j)) ind2 = ind2 + 1
	   if (dabs(CutPointX(j,k2)-X_Vert(i,j))).le.eps_cut) ind3 = ind3 + 1
	   end do   !!! k2

        ind1 = ind1 - (ind1/2)*2
        ind2 = ind2 - (ind2/2)*2
		
		if (ind1.gt.0.and.ind2.gt.0) Type_BF(i,j) = 1
		
		if (ind3.gt.0) Type_BF(i,j) = 2

	   end do  !!!  j
	   end do  !!!  i


!!!   Check all potential cut elements and define exact number of cut elements

	   NCUT = 0
       do i=0, NPOX-1
	   do j=0, NPOY-1

       if (IJ_CUT(i,j).ne.0) then
       
       ind1 = 0
       do k1 = i,i+1
       do k2 = j,j+1
       if (Type_BF(k1,k2).eq.1) ind1 = ind1 + 1
       end do !!! k2
       end do !!! k1
       
       if (ind1.gt.0.and.ind1.lt.4) then
           NCUT = NCUT + 1
           NP_CUT(i,j) = NCUT
           IK_CUT(NCUT) = i
           JK_CUT(NCUT) = j
       else
          IJ_CUT(i,j) = 0  
       end if   !!!  ind1
  
  	   end if   !!!  IJ_CUT(i,j)

	   end do  !!!  j
	   end do  !!!  i


!!!   Check all cut elements to define all external basis functions (TYPE_BF = 2 or 3)
!!!   and calculate number of boundary points


	   do i=0, NPOX-1
	   do j=0, NPOY-1

       if (IJ_CUT(i,j).ne.0) then
       kk = IJ_CUT(i,j)
       do k1 = i,i+1
       do k2 = j,j+1
       
       if (Type_BF(k1,k2).eq.1) then
	   
	   do k3 = k1-NFUP_BF/2,k1+NFUP_BF/2
	   do k4 = k2-NFUP_BF/2,k2+NFUP_BF/2
       if (k3.lt.0.or.k3.gt.NPOX) cycle
       if (k4.lt.0.or.k3.gt.NPOY) cycle
	   if (Type_BF(k3,k4).eq.0.or.Type_BF(k3,k4).eq.3) Type_BF(k1,k2) = 2
	   if (BC_Cut(k1,k2).eq.0.and.Type_BF(k1,k2).eq.2) then
	   BC_Cut(k1,k2) = kk
	   NPOINT_BC(kk) = NPOINT_BC(kk) + 1
	   end if
       end do !!! k4
       end do !!! k3	   
       
       end if   !!! Type_BF(k1,k2).eq.1
	   
       end do !!! k2
       end do !!! k1
  
       do k1 = i-NFUP_BF/2,i+NFUP_BF/2+1
       do k2 = j-NFUP_BF/2,j+NFUP_BF/2+1
       
	   if (k1.lt.0.or.k1.gt.NPOX) cycle
       if (k2.lt.0.or.k2.gt.NPOY) cycle
       if (Type_BF(k1,k2).eq.0) Type_BF(k1,k2) = 3

       end do !!! k2
       end do !!! k1
  
       end if   !!! IJ_CUT

	   end do  !!!  j
	   end do  !!!  i

!!!   Sum all internal basis functions - Type_BF(i,j)=1; all external basis functions which are related to the 
!!!   number of boundary conditions for each boundary curve - Type_BF(i,j)=2; and all external basis functions which 
!!!   do not cut the boundary curves - Type_BF(i,j)=3 

	   NPOINT_EQ = 0
	   NPOINT_BC_TOT = 0
	   NPOINT_EX = 0
       
       do i=0, NPOX
	   do j=0, NPOY

       if (Type_BF(i,j).eq.1) NPOINT_EQ = NPOINT_EQ + 1
       if (Type_BF(i,j).eq.2) NPOINT_BC_TOT = NPOINT_BC_TOT + 1
       if (Type_BF(i,j).eq.3) NPOINT_EX = NPOINT_EX + 1
       end do  !!!  j
	   end do  !!!  i
       NPOINT_OUT = (NPOX+1)*(NPOY+1)-NPOINT_EQ-NPOINT_BC_TOT-NPOINT_EX

!!!   Creates grid statistics for all cut elements; firstly find all vertices of internal poygon (Type_BF=1)
!!!   and creates stencil for each of them on cut element; also write all related information about cut element
!!!   Nadji grid statistiku za cut elemente; prvo nadji sve točke unutrasnjeg poligona (Type_BF=1) na cut
!!!   elementu i kreiraj polje indeksa koje im pripada 

       NCUT = 0
	   do i=0, NPOX-1
	   do j=0, NPOY-1

       if (IJ_CUT(i,j).ne.0) then
       
!!!   Find global indexes on cut element
!!!   Nadji globalne indekse na cut elementu

       NCUT = NCUT + 1 
       
 
       do k1 = i,i+1
       do k2 = j,j+1
       

       k = 0

       if (Type_BF(k1,k2).eq.1) then
	   
       k = k + 1
       if (k1.eq.i  .and.k2.eq.j  ) Type_CUT(NCUT,k) = 1
       if (k1.eq.i+1.and.k2.eq.j  ) Type_CUT(NCUT,k) = 2
       if (k1.eq.i+1.and.k2.eq.j+1) Type_CUT(NCUT,k) = 3
       if (k1.eq.i  .and.k2.eq.j+1) Type_CUT(NCUT,k) = 4
       
       I_Point_CUT(NCUT,k) = k1
       J_Point_CUT(NCUT,k) = k2
       Int_Point(NCUT,k) = IJ_POINT(k1,k2)
       k5 = 0
       do k3 = k1-NFUP_BF/2,k1+NFUP_BF/2
	   do k4 = k2-NFUP_BF/2,k2+NFUP_BF/2
       k5 = k5 + 1
       if (k1.lt.0.or.k1.gt.NPOX) exit
       if (k2.lt.0.or.k2.gt.NPOY) exit
	   CGlobal(k5)=IJ_POINT(k3,k4)
       end do !!! k4
       end do !!! k3
       
       call GRID_CUT(Type_CUT(NCUT,k),CGlobal,CLocal)
       
!!!  Write stencil for this internal point on the current cut element

       do k3 = 1, (NFUP_BF+2)**2
       Stencil_CUT(NCUT,k,k3) = Clocal(k3)
       end do   !!! k3
       
       end if   !!! Type_BF(k1,k2).eq.1
	   
       end do !!! k2
       end do !!! k1
       
       Local_Int_Point(NCUT) = k
  

	   end do  !!!  j
	   end do  !!!  i


!!!  Find all boundary points, related cut elements and stencil

       do i = 1, N_ext_BC
       NPOINT_BC(i) = NPOINT_BC(i) - 3
	   dt = 1.0d0 / dfloat(NPOINT_BC(i)+1)
       tt = 0.0d0
       
           do j = 1, NPOINT_BC(i)
           tt = tt + dt
           Call BCurve_value(i,tt,xt,yt)
	       IK = int4((xt-XGrid0)/DeltaX)
	       JK = int4((yt-Ygrid0)/DeltaY)
           XPOINT1 = xt
           YPOINT1 = yt
!!!   Find corresponding internal collocation point on cut element, the neareast point to (xt,yt)
           NCUT = NP_CUT(IK,JK)
           k1 = Local_Int_Point(NCUT)
           dd = 1.0d9
           ind = 0
           do k = 1, k1
           k2 = I_Point_CUT(NCUT,k) 
           k3 = J_Point_CUT(NCUT,k)
           XPOINT2 = X_Vert(k2,k3)
           YPOINT2 = Y_Vert(k2,k3)
           dd1  = Distance(XPOINT1,YPOINT1,XPOINT2,YPOINT2)
           if (dd1.lt.dd) then
           ind = k
           ind2 = k2
           ind3 = k3
           dd = dd1
           end if  !!!  dd1
           end do  !!!  k
!!!   Write boundary point coordinates, type of dif.equations, type and value of boundary conditions,
!!!   type of related internal collocation points on cut element, indexes of local and global basis 
!!!   functions on cut element

           XPOINT_BC(i,j) = xt - X_Vert(ind2,ind3)
           YPOINT_BC(i,j) = yt - Y_Vert(ind2,ind3)
           Call BCurve_normal(i,tt,n_x,n_y)
           Normal_x_BC(i,j) = n_x
           Normal_y_BC(i,j) = n_y
           Type_CUT_BC(i,j) = Type_CUT(NCUT,ind)
           do k=1,(NFUP_BF+2)**2
           C_index_BC(i,j,k)= Stencil_CUT(NCUT,ind,k)
           end do  !!! j
       end do      !!! i



       
       
       End Subroutine
	   
!!!  Transform indexes of Fup coefficients from global to local array depending of type of local cut
!!!  element coodinate system
!!!  Transformira indekse Fup koeficijenata iz globalnog polja u lokalno ovisno o tipu lokalnog koordinatnog sustava
!!!  na cut elementu

	   
	   Subroutine GRID_CUT(Type_CUT_CC,CC_Global,CC_Local) 
	   
	   integer*4  Type_CUT_CC,CC_Global((NFUP_BF+2)**2),CC_Local((NFUP_BF+2)**2)

       if (NFUP_BF.eq.2) then

          if (Type_CUT_CC.eq.1) then
		  
		  CC_Local(1) = CC_Global(1)
	      CC_Local(2) = CC_Global(2)
		  CC_Local(3) = CC_Global(3)
	      CC_Local(4) = CC_Global(5)
		  CC_Local(5) = CC_Global(6)
	      CC_Local(6) = CC_Global(7)
		  CC_Local(7) = CC_Global(9)
	      CC_Local(8) = CC_Global(10)
		  CC_Local(9) = CC_Global(11)
	      CC_Local(10) = CC_Global(13)
		  CC_Local(11) = CC_Global(14)
	      CC_Local(12) = CC_Global(15)
		  CC_Local(13) = CC_Global(4)
	      CC_Local(14) = CC_Global(8)
		  CC_Local(15) = CC_Global(12)
	      CC_Local(16) = CC_Global(16)
	  		  
          end if

          if (Type_CUT_CC.eq.2) then
		  
		  CC_Local(1) = CC_Global(13)
	      CC_Local(2) = CC_Global(14)
		  CC_Local(3) = CC_Global(15)
	      CC_Local(4) = CC_Global(9)
		  CC_Local(5) = CC_Global(10)
	      CC_Local(6) = CC_Global(11)
		  CC_Local(7) = CC_Global(5)
	      CC_Local(8) = CC_Global(6)
		  CC_Local(9) = CC_Global(7)
	      CC_Local(10) = CC_Global(1)
		  CC_Local(11) = CC_Global(2)
	      CC_Local(12) = CC_Global(3)
		  CC_Local(13) = CC_Global(16)
	      CC_Local(14) = CC_Global(12)
		  CC_Local(15) = CC_Global(8)
	      CC_Local(16) = CC_Global(4)
		  
		  end if
	  		  
          if (Type_CUT_CC.eq.3) then
		  
		  CC_Local(1) = CC_Global(16)
	      CC_Local(2) = CC_Global(15)
		  CC_Local(3) = CC_Global(14)
	      CC_Local(4) = CC_Global(12)
		  CC_Local(5) = CC_Global(11)
	      CC_Local(6) = CC_Global(10)
		  CC_Local(7) = CC_Global(8)
	      CC_Local(8) = CC_Global(7)
		  CC_Local(9) = CC_Global(6)
	      CC_Local(10) = CC_Global(4)
		  CC_Local(11) = CC_Global(3)
	      CC_Local(12) = CC_Global(2)
		  CC_Local(13) = CC_Global(13)
	      CC_Local(14) = CC_Global(9)
		  CC_Local(15) = CC_Global(5)
	      CC_Local(16) = CC_Global(1)
	  		  


          end if

         if (Type_CUT_CC.eq.4) then
		  
		  CC_Local(1) = CC_Global(4)
	      CC_Local(2) = CC_Global(3)
		  CC_Local(3) = CC_Global(2)
	      CC_Local(4) = CC_Global(8)
		  CC_Local(5) = CC_Global(7)
	      CC_Local(6) = CC_Global(6)
		  CC_Local(7) = CC_Global(12)
	      CC_Local(8) = CC_Global(11)
		  CC_Local(9) = CC_Global(10)
	      CC_Local(10) = CC_Global(16)
		  CC_Local(11) = CC_Global(15)
	      CC_Local(12) = CC_Global(14)
		  CC_Local(13) = CC_Global(1)
	      CC_Local(14) = CC_Global(5)
		  CC_Local(15) = CC_Global(9)
	      CC_Local(16) = CC_Global(13)
	  		  


          end if



        end if	   
	   

	   End Subroutine
	   
!!!    Find cut point between two cut elements denoted by IK1,JK1 and IK2,JK2
!!!    In parametric domain cut point - tt_cut is placed between tt1 and tt2
!!!    Final result gives both values in parametric - tt_cut and real domain - XP_Cut,YP_Cut, respectively.
!!!    Use halving method
	   
	   Subroutine Find_cut_point(icurve,IK1,JK1,tt1,IK2,JK2,tt2,XCUT1,YCUT1,XCUT2,YCUT2,tt_cut,XP_Cut,YP_Cut)
	   INTEGER(4) icurve,IK1,JK1,IK2,JK2
	   REAL(8)    tt1,tt2,tt_cut,XP_Cut,YP_Cut,dd_cut
	   REAL(8)    XCUT1,YCUT1,XCUT2,YCUT2,dt,dcut1,dcut2,dcut3,dcut4
	   
	   Call Bcurve_Value(icurve,tt1,XP1,YP1)
	   Call Bcurve_Value(icurve,tt2,XP2,YP2)
	   
	   
	   dt = tt2 - tt1
	   XP_Cut = XP2
	   YP_Cut = YP2
	   dcut1 = dabs(XP2-XCUT1)
       dcut2 = dabs(XP2-XCUT2)
       dcut3 = dabs(YP2-YCUT1)
       dcut4 = dabs(YP2-YCUT2)
       dd_cut = DMIN1(dcut1,dcut2,dcut3,dcut4)
       
	   do while (dd_cut.gt.eps_cut)
	   
	   dt = dt / 2.0d0
	   Call Bcurve_Value(icurve,tt1+dt,XP_Cut,YP_Cut)
	   IK3 = int4((XP_Cut-XGrid0)/DeltaX)
	   JK3 = int4((YP_Cut-Ygrid0)/DeltaY)
	   if (IK1.eq.IK3.and.JK1.eq.JK3) then
	   IK1 = IK3
	   JK1 = JK3
	   tt1 = tt1 + dt	   
	   else
	   IK2 = IK3
	   JK2 = JK3
	   tt2 = tt2 - dt
	   dcut1 = dabs(XP_Cut-XCUT1)
       dcut2 = dabs(XP_Cut-XCUT2)
       dcut3 = dabs(YP_Cut-YCUT1)
       dcut4 = dabs(YP_Cut-YCUT2)
       dd_cut = DMIN1(dcut1,dcut2,dcut3,dcut4)
       end if   !!!  IK1,IK3,JK1,JK3
	   	   
	   end do   !!!  while	   
	   
	   
	   End Subroutine
	   
       Real*8 Function Distance(XP1,YP1,XP2,YP2)
       
       Real(8) XP1,YP1,XP2,YP2
       
       Distance = dsqrt((xp2-xp1)**2+(yp2-yp1)**2)  
       
       End Function Distance	   
      
       End Module Geometry 
       
             

!!!  Main program for Shifted Boundary Fup Collocation Method - SBFCM

      
PROGRAM SBFCM

use FUP_0_16_D
use Global_Data
use Geometry


!!!  Generiraj Fup bazne funkcije

call Racun

!!!  Ucitaj ulazne podatke

	call Input
	
!!!  Generiraj rubne krivulje i geometrijske parametre

	call Boundary_curves
	
!!!  Generiraj 2-D grid i sve parametre vezane za opcu geometriju
	
	call Grid2D

	
End PROGRAM SBFCM
	  
       
	   
	   
